use std::io::{stdin, stdout, Write};

use anyhow::{Context, Result};
use chrono::NaiveDate;
use date::{parse_absolute, parse_relative};

pub mod date;

pub fn read_pass(question: &str) -> Result<String> {
    rpassword::prompt_password(format!("{question}: "))
            .context("failed to create passphrase prompt")
}

pub fn read_plain(question: &str) -> Result<String> {
    print!("{question}: ");
    stdout().flush().context("failed to flush stdout")?;

    let mut line = String::new();
    stdin().read_line(&mut line).context("failed to read line from stdin")?;

    Ok(line.trim().to_owned())
}

pub fn read_date(question: &str, current: NaiveDate) -> Result<Option<NaiveDate>> {
    let input = read_plain(question)?;

    // return none if user wants to exit
    if input == "exit" {
        return Ok(None);
    }

    if let Some(actual) = input.strip_prefix("absolute").or(input.strip_prefix("abs")) {
        parse_absolute(actual.trim())
    } else {
        parse_relative(&input, current)
    }
        .map(Some)
}
