use std::{env, fs, path::PathBuf};

use serde::Deserialize;

const CONFIG: &str = "me.toml";

fn get_config_home() -> PathBuf {
    env::var("XDG_CONFIG_HOME")
        .map(PathBuf::from)
        .or_else(|_| env::var("HOME").map(|str| PathBuf::from(str).join(".config")))
        .expect("cannot find config home on this system")
}

#[derive(Deserialize)]
pub struct GlobalConfig {
    pub repository: String
}

impl GlobalConfig {
    pub fn read() -> Option<Self> {
        let file = get_config_home().join(CONFIG);
        if !file.exists() { return None; }

        let Ok(string) = fs::read_to_string(file) else {
            eprintln!("global file exists but cannot be read");
            return None;
        };

        match toml::from_str(&string) {
            Ok(g) => Some(g),
            Err(e) => {
                eprintln!("failed to parse global file:\n {}", e.message());
                None
            }
        }
    }
}
