use clap::{Parser, Subcommand};

#[derive(Parser)]
#[clap(about)]
#[command(disable_help_subcommand = true, override_usage="me [OPTIONS]\n       me [OPTIONS] [DATE]...\n       me [OPTIONS] [COMMAND]")]
pub struct Args {

    /// do some specific action
    #[clap(subcommand)]
    pub command: Option<Command>,

    /// date to view or edit (default is today)
    #[arg(trailing_var_arg = true)]
    pub date: Option<Vec<String>>,

    /// override repository path
    #[clap(short, long)]
    pub repository: Option<String>,

    /// force the editing of arbitrary dates
    #[clap(short, long)]
    pub force: bool,

    /// do private insertion into note via password prompt
    #[clap(short, long)]
    pub void: bool,

    /// don't update from git remote
    #[clap(short, long, help_heading="Git Options")]
    pub offline: bool,

    /// don't interact with git alltogether
    #[clap(short, long, conflicts_with="offline", help_heading="Git Options")]
    pub gitless: bool,
}

#[derive(Subcommand)]
pub enum Command {
    /// browse all journal entries in a tui overview
    Browse
}
