- why is it not a shell script?

## Future
Possible features I might implement at some point:
- [ ] Named Entries. Specify `--name` and the query passed to the command becomes the name of a note *outside* the date based system which can be edited at any time. Warning, make sure the user cannot pass the name of a dated note to bypass the editing block.
  - Other idea: names might give too much away about the content. So i propose if the user types `me note` it opens an fzf like menu where the user can select a named entry (note) or create a new one.
  - We have a file `.notes` which is encrypted and contains a map from name to id, where id is a random assortment of letters which is the file name stored on disk.
- [ ] Disable sanity checking with `--insane`
- [ ] Pass passphrase via environment variable
- [X] Git integration (auto pull and commit & push) (bypass pull and push via --offline). Only commit files known to be changed.
- [X] Ssh-agent based key management. Start an ssh-agent as a subprocess (see manpage) and use it for git. Store a password-less key in e.g. .ssh-key that is decrypted and added to the agent with the passphrase of the repo. Disable git integraion in insane mode.
- [X] Use extra fd for gpg password instead of arg (use --pasphrase-fd)
- [X] Add daybreak override which allows one to add stuff to the previous day if early enough in the morning. (To adjust to sleep schedules).
- [ ] use tmpfile crate for protection against kills
- [X] disable symkey cache for gpg (use `--no-symkey-cache`), don't know whether that does something with `--batch` but it might
- [ ] more nice error display
- [ ] some sort of locking when editing a file (so we don't open the same thing multiple times)
- [X] chain mode, to open many days after each other without having to reenter the password
- [X] stats command, to see which days had how many edits (now that we have git integration)
- [X] void command (type into void and be appended)
- [ ] maybe cache file which caches word count or somth.
- [ ] check for internet connection when started in non-offline mode with ping to host, and only connect via git if online

## Configuration
Here are all the options supported in a **repository configuration** file. This is the file located under `.config` in your repository.
```toml
# date format for file name of repository entries
date_format = "%Y-%m-%d"

# hour of the daybreak, hours below this number count to the last day
daybreak = 0

# === Editor Settings ===
[editor]

# command to use to edit files
editor = "vim"

# arguments that are passed to the command before the file name
arguments = []

# prompt shown instead when inserting with `--void`
void = "enter stuff to append to your entry (submit empty to exit)"

# === Encryption Settings ===
[encryption]

# make encrypted files ascii-armored instead of binary
armored = true

# cipher to use for encryption, see `gpg --version` for info about that
cipher = "AES256"

# whether to ensure that all files in the repository use the same password
# turning this off can break things like git integration, so it is not recommended to set to false
password_sanity = true

# === Git Integration Settings ===
[git]

# enables the git integration
enabled = false

# use the ssh key at `.ssh-key` to perform pulls and pushes
ssh = true

# don't push and pull automatically, just commit
force_offline = false

# date after which git was enabled, forever by default
since = "0000-01-01"

# customization options for the commit message, see the code for that
message = { ... }
```

## Useful Commands
Here are couple of useful commands when working with a journal managed by `me`.

### Changing Password
To change the password of your journal, follow these steps:
1. **MAKE A BACKUP OR GIT COMMIT**
2. Write your old password to a file at `/tmp/me/old`
3. Write your new password to a file at `/tmp/me/new`
4. Run the following command(s) in your repository
   ```sh
   for f in *; do
       echo "Migrating entry ${f}";
       gpg --batch --passphrase-file=/tmp/me/old --no-symkey-cache --quiet -d ${f} | gpg --batch --yes --passphrase-file=/tmp/me/new --no-symkey-cache --quiet -c -o ${f}
   done;
   ```
5. Delete the sanity file (`.sanity` in the repo)
6. Open an entry and confirm the new password is working
7. Delete the directory `/tmp/me`
